package io.burkard.cdk.cxapi

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AwsCloudFormationStackProperties {

  def apply(
    templateFile: String,
    parameters: Option[Map[String, String]] = None,
    stackName: Option[String] = None,
    terminationProtection: Option[Boolean] = None
  ): software.amazon.awscdk.cxapi.AwsCloudFormationStackProperties =
    (new software.amazon.awscdk.cxapi.AwsCloudFormationStackProperties.Builder)
      .templateFile(templateFile)
      .parameters(parameters.map(_.asJava).orNull)
      .stackName(stackName.orNull)
      .terminationProtection(terminationProtection.map(Boolean.box).orNull)
      .build()
}
