package io.burkard.cdk.services.sam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHttpApiProps {

  def apply(
    corsConfiguration0: Option[software.amazon.awscdk.services.sam.CfnHttpApi.CorsConfigurationObjectProperty] = None,
    corsConfiguration1: Option[Boolean] = None,
    auth: Option[software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiAuthProperty] = None,
    routeSettings: Option[software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty] = None,
    defaultRouteSettings: Option[software.amazon.awscdk.services.sam.CfnHttpApi.RouteSettingsProperty] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    domain: Option[software.amazon.awscdk.services.sam.CfnHttpApi.HttpApiDomainConfigurationProperty] = None,
    failOnWarnings: Option[Boolean] = None,
    definitionBody: Option[AnyRef] = None,
    stageName: Option[String] = None,
    disableExecuteApiEndpoint: Option[Boolean] = None,
    accessLogSetting: Option[software.amazon.awscdk.services.sam.CfnHttpApi.AccessLogSettingProperty] = None,
    definitionUri0: Option[software.amazon.awscdk.services.sam.CfnHttpApi.S3LocationProperty] = None,
    definitionUri1: Option[String] = None,
    stageVariables: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.sam.CfnHttpApiProps =
    (new software.amazon.awscdk.services.sam.CfnHttpApiProps.Builder)
      .corsConfiguration(corsConfiguration0.orNull)
      .corsConfiguration(corsConfiguration1.map(Boolean.box).orNull)
      .auth(auth.orNull)
      .routeSettings(routeSettings.orNull)
      .defaultRouteSettings(defaultRouteSettings.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .domain(domain.orNull)
      .failOnWarnings(failOnWarnings.map(Boolean.box).orNull)
      .definitionBody(definitionBody.orNull)
      .stageName(stageName.orNull)
      .disableExecuteApiEndpoint(disableExecuteApiEndpoint.map(Boolean.box).orNull)
      .accessLogSetting(accessLogSetting.orNull)
      .definitionUri(definitionUri0.orNull)
      .definitionUri(definitionUri1.orNull)
      .stageVariables(stageVariables.map(_.asJava).orNull)
      .build()
}
