package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpcEndpointServiceDomainName {

  def apply(
    internalResourceId: String,
    publicHostedZone: software.amazon.awscdk.services.route53.IPublicHostedZone,
    endpointService: software.amazon.awscdk.services.ec2.IVpcEndpointService,
    domainName: String
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName =
    software.amazon.awscdk.services.route53.VpcEndpointServiceDomainName.Builder
      .create(stackCtx, internalResourceId)
      .publicHostedZone(publicHostedZone)
      .endpointService(endpointService)
      .domainName(domainName)
      .build()
}
