package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnADMChannel {

  def apply(
    internalResourceId: String,
    applicationId: String,
    clientId: String,
    clientSecret: String,
    enabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnADMChannel =
    software.amazon.awscdk.services.pinpoint.CfnADMChannel.Builder
      .create(stackCtx, internalResourceId)
      .applicationId(applicationId)
      .clientId(clientId)
      .clientSecret(clientSecret)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
