package io.burkard.cdk.services.mediaconnect

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFlowProps {

  def apply(
    name: String,
    source: software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceProperty,
    availabilityZone: Option[String] = None,
    sourceFailoverConfig: Option[software.amazon.awscdk.services.mediaconnect.CfnFlow.FailoverConfigProperty] = None
  ): software.amazon.awscdk.services.mediaconnect.CfnFlowProps =
    (new software.amazon.awscdk.services.mediaconnect.CfnFlowProps.Builder)
      .name(name)
      .source(source)
      .availabilityZone(availabilityZone.orNull)
      .sourceFailoverConfig(sourceFailoverConfig.orNull)
      .build()
}
