package io.burkard.cdk.services.kms

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AliasProps {

  def apply(
    aliasName: String,
    targetKey: software.amazon.awscdk.services.kms.IKey,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None
  ): software.amazon.awscdk.services.kms.AliasProps =
    (new software.amazon.awscdk.services.kms.AliasProps.Builder)
      .aliasName(aliasName)
      .targetKey(targetKey)
      .removalPolicy(removalPolicy.orNull)
      .build()
}
