package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ServicePrincipal {

  def apply(
    service: String,
    region: Option[String] = None,
    conditions: Option[Map[String, _]] = None
  ): software.amazon.awscdk.services.iam.ServicePrincipal =
    software.amazon.awscdk.services.iam.ServicePrincipal.Builder
      .create(service)
      .region(region.orNull)
      .conditions(conditions.map(_.asJava).orNull)
      .build()
}
