package io.burkard.cdk.services.elasticache

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSecurityGroupProps {

  def apply(
    description: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.elasticache.CfnSecurityGroupProps =
    (new software.amazon.awscdk.services.elasticache.CfnSecurityGroupProps.Builder)
      .description(description)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
