package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TaskDefinitionAttributes {

  def apply(
    networkMode: Option[software.amazon.awscdk.services.ecs.NetworkMode] = None,
    compatibility: Option[software.amazon.awscdk.services.ecs.Compatibility] = None,
    taskDefinitionArn: Option[String] = None,
    taskRole: Option[software.amazon.awscdk.services.iam.IRole] = None
  ): software.amazon.awscdk.services.ecs.TaskDefinitionAttributes =
    (new software.amazon.awscdk.services.ecs.TaskDefinitionAttributes.Builder)
      .networkMode(networkMode.orNull)
      .compatibility(compatibility.orNull)
      .taskDefinitionArn(taskDefinitionArn.orNull)
      .taskRole(taskRole.orNull)
      .build()
}
