package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptions {

  def apply(
    kmsKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None,
    encrypted: Option[Boolean] = None,
    iops: Option[Number] = None,
    deleteOnTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceOptions =
    (new software.amazon.awscdk.services.ec2.EbsDeviceOptions.Builder)
      .kmsKey(kmsKey.orNull)
      .volumeType(volumeType.orNull)
      .encrypted(encrypted.map(Boolean.box).orNull)
      .iops(iops.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
