package io.burkard.cdk.services.datasync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocationFSxLustreProps {

  def apply(
    fsxFilesystemArn: String,
    securityGroupArns: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    subdirectory: Option[String] = None
  ): software.amazon.awscdk.services.datasync.CfnLocationFSxLustreProps =
    (new software.amazon.awscdk.services.datasync.CfnLocationFSxLustreProps.Builder)
      .fsxFilesystemArn(fsxFilesystemArn)
      .securityGroupArns(securityGroupArns.asJava)
      .tags(tags.map(_.asJava).orNull)
      .subdirectory(subdirectory.orNull)
      .build()
}
