package io.burkard.cdk.services.codedeploy

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LambdaDeploymentGroupProps {

  def apply(
    alias: software.amazon.awscdk.services.lambda.Alias,
    application: Option[software.amazon.awscdk.services.codedeploy.ILambdaApplication] = None,
    deploymentConfig: Option[software.amazon.awscdk.services.codedeploy.ILambdaDeploymentConfig] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    ignorePollAlarmsFailure: Option[Boolean] = None,
    autoRollback: Option[software.amazon.awscdk.services.codedeploy.AutoRollbackConfig] = None,
    alarms: Option[List[_ <: software.amazon.awscdk.services.cloudwatch.IAlarm]] = None,
    preHook: Option[software.amazon.awscdk.services.lambda.IFunction] = None,
    deploymentGroupName: Option[String] = None,
    postHook: Option[software.amazon.awscdk.services.lambda.IFunction] = None
  ): software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupProps =
    (new software.amazon.awscdk.services.codedeploy.LambdaDeploymentGroupProps.Builder)
      .alias(alias)
      .application(application.orNull)
      .deploymentConfig(deploymentConfig.orNull)
      .role(role.orNull)
      .ignorePollAlarmsFailure(ignorePollAlarmsFailure.map(Boolean.box).orNull)
      .autoRollback(autoRollback.orNull)
      .alarms(alarms.map(_.asJava).orNull)
      .preHook(preHook.orNull)
      .deploymentGroupName(deploymentGroupName.orNull)
      .postHook(postHook.orNull)
      .build()
}
