package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReportGroupProps {

  def apply(
    zipExport: Option[Boolean] = None,
    exportBucket: Option[software.amazon.awscdk.services.s3.IBucket] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    reportGroupName: Option[String] = None
  ): software.amazon.awscdk.services.codebuild.ReportGroupProps =
    (new software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder)
      .zipExport(zipExport.map(Boolean.box).orNull)
      .exportBucket(exportBucket.orNull)
      .removalPolicy(removalPolicy.orNull)
      .reportGroupName(reportGroupName.orNull)
      .build()
}
