package io.burkard.cdk.services.codebuild

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReportGroup {

  def apply(
    internalResourceId: String,
    zipExport: Option[Boolean] = None,
    exportBucket: Option[software.amazon.awscdk.services.s3.IBucket] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    reportGroupName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codebuild.ReportGroup =
    software.amazon.awscdk.services.codebuild.ReportGroup.Builder
      .create(stackCtx, internalResourceId)
      .zipExport(zipExport.map(Boolean.box).orNull)
      .exportBucket(exportBucket.orNull)
      .removalPolicy(removalPolicy.orNull)
      .reportGroupName(reportGroupName.orNull)
      .build()
}
