package io.burkard.cdk.services.cloudfront

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoggingConfiguration {

  def apply(
    prefix: Option[String] = None,
    includeCookies: Option[Boolean] = None,
    bucket: Option[software.amazon.awscdk.services.s3.IBucket] = None
  ): software.amazon.awscdk.services.cloudfront.LoggingConfiguration =
    (new software.amazon.awscdk.services.cloudfront.LoggingConfiguration.Builder)
      .prefix(prefix.orNull)
      .includeCookies(includeCookies.map(Boolean.box).orNull)
      .bucket(bucket.orNull)
      .build()
}
