package io.burkard.cdk.services.athena

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPreparedStatementProps {

  def apply(
    statementName: String,
    queryStatement: String,
    workGroup: String,
    description: Option[String] = None
  ): software.amazon.awscdk.services.athena.CfnPreparedStatementProps =
    (new software.amazon.awscdk.services.athena.CfnPreparedStatementProps.Builder)
      .statementName(statementName)
      .queryStatement(queryStatement)
      .workGroup(workGroup)
      .description(description.orNull)
      .build()
}
