package io.burkard.cdk.services.athena

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPreparedStatement {

  def apply(
    internalResourceId: String,
    statementName: String,
    queryStatement: String,
    workGroup: String,
    description: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.athena.CfnPreparedStatement =
    software.amazon.awscdk.services.athena.CfnPreparedStatement.Builder
      .create(stackCtx, internalResourceId)
      .statementName(statementName)
      .queryStatement(queryStatement)
      .workGroup(workGroup)
      .description(description.orNull)
      .build()
}
