package io.burkard.cdk.services.appstream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStackUserAssociationProps {

  def apply(
    userName: String,
    stackName: String,
    authenticationType: String,
    sendEmailNotification: Option[Boolean] = None
  ): software.amazon.awscdk.services.appstream.CfnStackUserAssociationProps =
    (new software.amazon.awscdk.services.appstream.CfnStackUserAssociationProps.Builder)
      .userName(userName)
      .stackName(stackName)
      .authenticationType(authenticationType)
      .sendEmailNotification(sendEmailNotification.map(Boolean.box).orNull)
      .build()
}
