package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VirtualServiceProviderConfig {

  def apply(
    mesh: software.amazon.awscdk.services.appmesh.IMesh,
    virtualNodeProvider: Option[software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualNodeServiceProviderProperty] = None,
    virtualRouterProvider: Option[software.amazon.awscdk.services.appmesh.CfnVirtualService.VirtualRouterServiceProviderProperty] = None
  ): software.amazon.awscdk.services.appmesh.VirtualServiceProviderConfig =
    (new software.amazon.awscdk.services.appmesh.VirtualServiceProviderConfig.Builder)
      .mesh(mesh)
      .virtualNodeProvider(virtualNodeProvider.orNull)
      .virtualRouterProvider(virtualRouterProvider.orNull)
      .build()
}
