package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileAssetSource {

  def apply(
    sourceHash: String,
    executable: Option[List[String]] = None,
    fileName: Option[String] = None,
    packaging: Option[software.amazon.awscdk.FileAssetPackaging] = None
  ): software.amazon.awscdk.FileAssetSource =
    (new software.amazon.awscdk.FileAssetSource.Builder)
      .sourceHash(sourceHash)
      .executable(executable.map(_.asJava).orNull)
      .fileName(fileName.orNull)
      .packaging(packaging.orNull)
      .build()
}
