package io.burkard.cdk.services.stepfunctions.tasks.emrCreateCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VolumeSpecificationProperty {

  def apply(
    volumeSize: software.amazon.awscdk.Size,
    volumeType: software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.EbsBlockDeviceVolumeType,
    iops: Option[Number] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty =
    (new software.amazon.awscdk.services.stepfunctions.tasks.EmrCreateCluster.VolumeSpecificationProperty.Builder)
      .volumeSize(volumeSize)
      .volumeType(volumeType)
      .iops(iops.orNull)
      .build()
}
