package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDomainProps {

  def apply(
    authMode: String,
    subnetIds: List[String],
    vpcId: String,
    domainName: String,
    defaultUserSettings: software.amazon.awscdk.services.sagemaker.CfnDomain.UserSettingsProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    appNetworkAccessType: Option[String] = None,
    kmsKeyId: Option[String] = None
  ): software.amazon.awscdk.services.sagemaker.CfnDomainProps =
    (new software.amazon.awscdk.services.sagemaker.CfnDomainProps.Builder)
      .authMode(authMode)
      .subnetIds(subnetIds.asJava)
      .vpcId(vpcId)
      .domainName(domainName)
      .defaultUserSettings(defaultUserSettings)
      .tags(tags.map(_.asJava).orNull)
      .appNetworkAccessType(appNetworkAccessType.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .build()
}
