package io.burkard.cdk.services.s3.deployment

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SourceConfig {

  def apply(
    zipObjectKey: String,
    bucket: software.amazon.awscdk.services.s3.IBucket,
    markers: Option[Map[String, _]] = None
  ): software.amazon.awscdk.services.s3.deployment.SourceConfig =
    (new software.amazon.awscdk.services.s3.deployment.SourceConfig.Builder)
      .zipObjectKey(zipObjectKey)
      .bucket(bucket)
      .markers(markers.map(_.asJava).orNull)
      .build()
}
