package io.burkard.cdk.services.robomaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRobotApplication {

  def apply(
    internalResourceId: String,
    robotSoftwareSuite: software.amazon.awscdk.services.robomaker.CfnRobotApplication.RobotSoftwareSuiteProperty,
    name: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    environment: Option[String] = None,
    currentRevisionId: Option[String] = None,
    sources: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.robomaker.CfnRobotApplication =
    software.amazon.awscdk.services.robomaker.CfnRobotApplication.Builder
      .create(stackCtx, internalResourceId)
      .robotSoftwareSuite(robotSoftwareSuite)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .environment(environment.orNull)
      .currentRevisionId(currentRevisionId.orNull)
      .sources(sources.map(_.asJava).orNull)
      .build()
}
