package io.burkard.cdk.services.rds.cfnDBCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScalingConfigurationProperty {

  def apply(
    minCapacity: Option[Number] = None,
    autoPause: Option[Boolean] = None,
    secondsUntilAutoPause: Option[Number] = None,
    maxCapacity: Option[Number] = None
  ): software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty =
    (new software.amazon.awscdk.services.rds.CfnDBCluster.ScalingConfigurationProperty.Builder)
      .minCapacity(minCapacity.orNull)
      .autoPause(autoPause.map(Boolean.box).orNull)
      .secondsUntilAutoPause(secondsUntilAutoPause.orNull)
      .maxCapacity(maxCapacity.orNull)
      .build()
}
