package io.burkard.cdk.services.rds

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ParameterGroupProps {

  def apply(
    engine: software.amazon.awscdk.services.rds.IEngine,
    parameters: Option[Map[String, String]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.rds.ParameterGroupProps =
    (new software.amazon.awscdk.services.rds.ParameterGroupProps.Builder)
      .engine(engine)
      .parameters(parameters.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
