package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRouteCalculatorProps {

  def apply(
    calculatorName: String,
    dataSource: String,
    description: Option[String] = None,
    pricingPlan: Option[String] = None
  ): software.amazon.awscdk.services.location.CfnRouteCalculatorProps =
    (new software.amazon.awscdk.services.location.CfnRouteCalculatorProps.Builder)
      .calculatorName(calculatorName)
      .dataSource(dataSource)
      .description(description.orNull)
      .pricingPlan(pricingPlan.orNull)
      .build()
}
