package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBucketProps {

  def apply(
    bundleId: String,
    bucketName: String,
    objectVersioning: Option[Boolean] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    accessRules: Option[software.amazon.awscdk.services.lightsail.CfnBucket.AccessRulesProperty] = None,
    resourcesReceivingAccess: Option[List[String]] = None,
    readOnlyAccessAccounts: Option[List[String]] = None
  ): software.amazon.awscdk.services.lightsail.CfnBucketProps =
    (new software.amazon.awscdk.services.lightsail.CfnBucketProps.Builder)
      .bundleId(bundleId)
      .bucketName(bucketName)
      .objectVersioning(objectVersioning.map(Boolean.box).orNull)
      .tags(tags.map(_.asJava).orNull)
      .accessRules(accessRules.orNull)
      .resourcesReceivingAccess(resourcesReceivingAccess.map(_.asJava).orNull)
      .readOnlyAccessAccounts(readOnlyAccessAccounts.map(_.asJava).orNull)
      .build()
}
