package io.burkard.cdk.services.kinesisanalyticsv2.cfnApplication

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InputSchemaProperty {

  def apply(
    recordFormat: software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.RecordFormatProperty,
    recordColumns: List[_],
    recordEncoding: Option[String] = None
  ): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.InputSchemaProperty =
    (new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.InputSchemaProperty.Builder)
      .recordFormat(recordFormat)
      .recordColumns(recordColumns.asJava)
      .recordEncoding(recordEncoding.orNull)
      .build()
}
