package io.burkard.cdk.services.kinesisanalytics.cfnApplicationV2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CheckpointConfigurationProperty {

  def apply(
    configurationType: String,
    minPauseBetweenCheckpoints: Option[Number] = None,
    checkpointingEnabled: Option[Boolean] = None,
    checkpointInterval: Option[Number] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.CheckpointConfigurationProperty.Builder)
      .configurationType(configurationType)
      .minPauseBetweenCheckpoints(minPauseBetweenCheckpoints.orNull)
      .checkpointingEnabled(checkpointingEnabled.map(Boolean.box).orNull)
      .checkpointInterval(checkpointInterval.orNull)
      .build()
}
