package io.burkard.cdk.services.globalaccelerator

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnListener {

  def apply(
    internalResourceId: String,
    protocol: String,
    portRanges: List[_],
    acceleratorArn: String,
    clientAffinity: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.globalaccelerator.CfnListener =
    software.amazon.awscdk.services.globalaccelerator.CfnListener.Builder
      .create(stackCtx, internalResourceId)
      .protocol(protocol)
      .portRanges(portRanges.asJava)
      .acceleratorArn(acceleratorArn)
      .clientAffinity(clientAffinity.orNull)
      .build()
}
