package io.burkard.cdk.services.fsx.cfnFileSystem

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OpenZFSConfigurationProperty {

  def apply(
    deploymentType: String,
    copyTagsToVolumes: Option[Boolean] = None,
    dailyAutomaticBackupStartTime: Option[String] = None,
    rootVolumeConfiguration: Option[software.amazon.awscdk.services.fsx.CfnFileSystem.RootVolumeConfigurationProperty] = None,
    weeklyMaintenanceStartTime: Option[String] = None,
    diskIopsConfiguration: Option[software.amazon.awscdk.services.fsx.CfnFileSystem.DiskIopsConfigurationProperty] = None,
    throughputCapacity: Option[Number] = None,
    copyTagsToBackups: Option[Boolean] = None,
    automaticBackupRetentionDays: Option[Number] = None
  ): software.amazon.awscdk.services.fsx.CfnFileSystem.OpenZFSConfigurationProperty =
    (new software.amazon.awscdk.services.fsx.CfnFileSystem.OpenZFSConfigurationProperty.Builder)
      .deploymentType(deploymentType)
      .copyTagsToVolumes(copyTagsToVolumes.map(Boolean.box).orNull)
      .dailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime.orNull)
      .rootVolumeConfiguration(rootVolumeConfiguration.orNull)
      .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime.orNull)
      .diskIopsConfiguration(diskIopsConfiguration.orNull)
      .throughputCapacity(throughputCapacity.orNull)
      .copyTagsToBackups(copyTagsToBackups.map(Boolean.box).orNull)
      .automaticBackupRetentionDays(automaticBackupRetentionDays.orNull)
      .build()
}
