package io.burkard.cdk.services.forecast

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDatasetGroupProps {

  def apply(
    domain: String,
    datasetGroupName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    datasetArns: Option[List[String]] = None
  ): software.amazon.awscdk.services.forecast.CfnDatasetGroupProps =
    (new software.amazon.awscdk.services.forecast.CfnDatasetGroupProps.Builder)
      .domain(domain)
      .datasetGroupName(datasetGroupName)
      .tags(tags.map(_.asJava).orNull)
      .datasetArns(datasetArns.map(_.asJava).orNull)
      .build()
}
