package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KinesisStream {

  def apply(
    stream: software.amazon.awscdk.services.kinesis.IStream,
    message: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    partitionKeyPath: Option[String] = None
  ): software.amazon.awscdk.services.events.targets.KinesisStream =
    software.amazon.awscdk.services.events.targets.KinesisStream.Builder
      .create(stream)
      .message(message.orNull)
      .partitionKeyPath(partitionKeyPath.orNull)
      .build()
}
