package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CodePipelineTargetOptions {

  def apply(
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    eventRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    retryAttempts: Option[Number] = None
  ): software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions =
    (new software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder)
      .deadLetterQueue(deadLetterQueue.orNull)
      .maxEventAge(maxEventAge.orNull)
      .eventRole(eventRole.orNull)
      .retryAttempts(retryAttempts.orNull)
      .build()
}
