package io.burkard.cdk.services.events.cfnConnection

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OAuthParametersProperty {

  def apply(
    authorizationEndpoint: String,
    clientParameters: software.amazon.awscdk.services.events.CfnConnection.ClientParametersProperty,
    httpMethod: String,
    oAuthHttpParameters: Option[software.amazon.awscdk.services.events.CfnConnection.ConnectionHttpParametersProperty] = None
  ): software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty =
    (new software.amazon.awscdk.services.events.CfnConnection.OAuthParametersProperty.Builder)
      .authorizationEndpoint(authorizationEndpoint)
      .clientParameters(clientParameters)
      .httpMethod(httpMethod)
      .oAuthHttpParameters(oAuthHttpParameters.orNull)
      .build()
}
