package io.burkard.cdk.services.events

sealed abstract class HttpMethod(val underlying: software.amazon.awscdk.services.events.HttpMethod)
  extends Product
    with Serializable

object HttpMethod {
  implicit def toAws(value: HttpMethod): software.amazon.awscdk.services.events.HttpMethod =
    Option(value).map(_.underlying).orNull

  case object Post
    extends HttpMethod(software.amazon.awscdk.services.events.HttpMethod.POST)

  case object Get
    extends HttpMethod(software.amazon.awscdk.services.events.HttpMethod.GET)

  case object Head
    extends HttpMethod(software.amazon.awscdk.services.events.HttpMethod.HEAD)

  case object Options
    extends HttpMethod(software.amazon.awscdk.services.events.HttpMethod.OPTIONS)

  case object Put
    extends HttpMethod(software.amazon.awscdk.services.events.HttpMethod.PUT)

  case object Patch
    extends HttpMethod(software.amazon.awscdk.services.events.HttpMethod.PATCH)

  case object Delete
    extends HttpMethod(software.amazon.awscdk.services.events.HttpMethod.DELETE)
}
