package io.burkard.cdk.services.elasticache

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSubnetGroup {

  def apply(
    internalResourceId: String,
    description: String,
    subnetIds: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    cacheSubnetGroupName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.elasticache.CfnSubnetGroup =
    software.amazon.awscdk.services.elasticache.CfnSubnetGroup.Builder
      .create(stackCtx, internalResourceId)
      .description(description)
      .subnetIds(subnetIds.asJava)
      .tags(tags.map(_.asJava).orNull)
      .cacheSubnetGroupName(cacheSubnetGroupName.orNull)
      .build()
}
