package io.burkard.cdk.services.ecs.cfnService

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoadBalancerProperty {

  def apply(
    containerPort: Number,
    targetGroupArn: Option[String] = None,
    loadBalancerName: Option[String] = None,
    containerName: Option[String] = None
  ): software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty =
    (new software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty.Builder)
      .containerPort(containerPort)
      .targetGroupArn(targetGroupArn.orNull)
      .loadBalancerName(loadBalancerName.orNull)
      .containerName(containerName.orNull)
      .build()
}
