package io.burkard.cdk.services.ecr

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPublicRepositoryProps {

  def apply(
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    repositoryPolicyText: Option[AnyRef] = None,
    repositoryCatalogData: Option[AnyRef] = None,
    repositoryName: Option[String] = None
  ): software.amazon.awscdk.services.ecr.CfnPublicRepositoryProps =
    (new software.amazon.awscdk.services.ecr.CfnPublicRepositoryProps.Builder)
      .tags(tags.map(_.asJava).orNull)
      .repositoryPolicyText(repositoryPolicyText.orNull)
      .repositoryCatalogData(repositoryCatalogData.orNull)
      .repositoryName(repositoryName.orNull)
      .build()
}
