package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpcEndpointService {

  def apply(
    internalResourceId: String,
    vpcEndpointServiceLoadBalancers: List[_ <: software.amazon.awscdk.services.ec2.IVpcEndpointServiceLoadBalancer],
    acceptanceRequired: Option[Boolean] = None,
    allowedPrincipals: Option[List[_ <: software.amazon.awscdk.services.iam.ArnPrincipal]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.VpcEndpointService =
    software.amazon.awscdk.services.ec2.VpcEndpointService.Builder
      .create(stackCtx, internalResourceId)
      .vpcEndpointServiceLoadBalancers(vpcEndpointServiceLoadBalancers.asJava)
      .acceptanceRequired(acceptanceRequired.map(Boolean.box).orNull)
      .allowedPrincipals(allowedPrincipals.map(_.asJava).orNull)
      .build()
}
