package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object PublicSubnetProps {

  def apply(
    availabilityZone: Option[String] = None,
    cidrBlock: Option[String] = None,
    mapPublicIpOnLaunch: Option[Boolean] = None,
    vpcId: Option[String] = None
  ): software.amazon.awscdk.services.ec2.PublicSubnetProps =
    (new software.amazon.awscdk.services.ec2.PublicSubnetProps.Builder)
      .availabilityZone(availabilityZone.orNull)
      .cidrBlock(cidrBlock.orNull)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .vpcId(vpcId.orNull)
      .build()
}
