package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FlowLog {

  def apply(
    internalResourceId: String,
    resourceType: software.amazon.awscdk.services.ec2.FlowLogResourceType,
    destination: Option[software.amazon.awscdk.services.ec2.FlowLogDestination] = None,
    trafficType: Option[software.amazon.awscdk.services.ec2.FlowLogTrafficType] = None,
    flowLogName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.FlowLog =
    software.amazon.awscdk.services.ec2.FlowLog.Builder
      .create(stackCtx, internalResourceId)
      .resourceType(resourceType)
      .destination(destination.orNull)
      .trafficType(trafficType.orNull)
      .flowLogName(flowLogName.orNull)
      .build()
}
