package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceSnapshotOptions {

  def apply(
    volumeSize: Option[Number] = None,
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None,
    deleteOnTermination: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions =
    (new software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions.Builder)
      .volumeSize(volumeSize.orNull)
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .build()
}
