package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTransitGatewayRouteProps {

  def apply(
    transitGatewayRouteTableId: String,
    destinationCidrBlock: Option[String] = None,
    blackhole: Option[Boolean] = None,
    transitGatewayAttachmentId: Option[String] = None
  ): software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteProps =
    (new software.amazon.awscdk.services.ec2.CfnTransitGatewayRouteProps.Builder)
      .transitGatewayRouteTableId(transitGatewayRouteTableId)
      .destinationCidrBlock(destinationCidrBlock.orNull)
      .blackhole(blackhole.map(Boolean.box).orNull)
      .transitGatewayAttachmentId(transitGatewayAttachmentId.orNull)
      .build()
}
