package io.burkard.cdk.services.cloudformation

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnHookTypeConfigProps {

  def apply(
    configuration: String,
    typeName: Option[String] = None,
    configurationAlias: Option[String] = None,
    typeArn: Option[String] = None
  ): software.amazon.awscdk.services.cloudformation.CfnHookTypeConfigProps =
    (new software.amazon.awscdk.services.cloudformation.CfnHookTypeConfigProps.Builder)
      .configuration(configuration)
      .typeName(typeName.orNull)
      .configurationAlias(configurationAlias.orNull)
      .typeArn(typeArn.orNull)
      .build()
}
