package io.burkard.cdk.services.appstream

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnStackUserAssociation {

  def apply(
    internalResourceId: String,
    userName: String,
    authenticationType: String,
    stackName: String,
    sendEmailNotification: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appstream.CfnStackUserAssociation =
    software.amazon.awscdk.services.appstream.CfnStackUserAssociation.Builder
      .create(stackCtx, internalResourceId)
      .userName(userName)
      .authenticationType(authenticationType)
      .stackName(stackName)
      .sendEmailNotification(sendEmailNotification.map(Boolean.box).orNull)
      .build()
}
