package io.burkard.cdk.services.applicationautoscaling.cfnScalingPolicy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StepAdjustmentProperty {

  def apply(
    scalingAdjustment: Number,
    metricIntervalLowerBound: Option[Number] = None,
    metricIntervalUpperBound: Option[Number] = None
  ): software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepAdjustmentProperty =
    (new software.amazon.awscdk.services.applicationautoscaling.CfnScalingPolicy.StepAdjustmentProperty.Builder)
      .scalingAdjustment(scalingAdjustment)
      .metricIntervalLowerBound(metricIntervalLowerBound.orNull)
      .metricIntervalUpperBound(metricIntervalUpperBound.orNull)
      .build()
}
