package io.burkard.cdk.services.appflow

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConnectorProfile {

  def apply(
    internalResourceId: String,
    connectorProfileName: String,
    connectorType: String,
    connectionMode: String,
    connectorProfileConfig: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileConfigProperty] = None,
    kmsArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.appflow.CfnConnectorProfile =
    software.amazon.awscdk.services.appflow.CfnConnectorProfile.Builder
      .create(stackCtx, internalResourceId)
      .connectorProfileName(connectorProfileName)
      .connectorType(connectorType)
      .connectionMode(connectionMode)
      .connectorProfileConfig(connectorProfileConfig.orNull)
      .kmsArn(kmsArn.orNull)
      .build()
}
