package io.burkard.cdk.services.s3.deployment

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SourceConfig {

  def apply(
    bucket: software.amazon.awscdk.services.s3.IBucket,
    zipObjectKey: String,
    markers: Option[Map[String, _]] = None
  ): software.amazon.awscdk.services.s3.deployment.SourceConfig =
    (new software.amazon.awscdk.services.s3.deployment.SourceConfig.Builder)
      .bucket(bucket)
      .zipObjectKey(zipObjectKey)
      .markers(markers.map(_.asJava).orNull)
      .build()
}
